
local assets=
{
	Asset("ANIM", "anim/lightarmor.zip"),
    Asset("ATLAS", "images/inventoryimages/lightarmor.xml"),
	Asset("IMAGE", "images/inventoryimages/lightarmor.tex"),	  
}


local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
end

local function healowner(inst, owner)
    if (owner.components.health and owner.components.health:IsHurt()) then
        owner.components.health:DoDelta(5*0.5,false,"redamulet")
    end
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "lightarmor", "swap_body") 
    inst:ListenForEvent("blocked", OnBlocked, owner)
	inst.task = inst:DoPeriodicTask(10, function() healowner(inst, owner) end)
	inst.components.equippable.insulated = true
	
	
end

local function onunequip(inst, owner) 
    if inst.task then inst.task:Cancel() inst.task = nil end
    owner.AnimState:ClearOverrideSymbol("swap_body")
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
end

local function fn()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("armor_trunkvest_summer")
    inst.AnimState:SetBuild("lightarmor")
    inst.AnimState:PlayAnimation("anim")
    

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
  	inst.components.inventoryitem.atlasname = "images/inventoryimages/lightarmor.xml"	
	inst.entity:AddMiniMapEntity()	
	inst.MiniMapEntity:SetIcon( "lightarmor.tex" )		
    
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(TUNING.ARMORWOOD*2, TUNING.ARMORWOOD_ABSORPTION*1.125)

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end

return Prefab( "common/inventory/lightarmor", fn, assets) 
